/*
 * Decompiled with CFR 0.152.
 */
package mcjty.lib.multipart;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mcjty.lib.multipart.IPartBlock;
import mcjty.lib.multipart.MultipartTE;
import mcjty.lib.multipart.PartSlot;
import mcjty.lib.setup.Registration;
import mcjty.lib.tileentity.GenericTileEntity;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class MultipartItemBlock
extends BlockItem {
    public MultipartItemBlock(Block block) {
        super(block, new Item.Properties());
    }

    public MultipartItemBlock(Block block, Item.Properties properties) {
        super(block, properties);
    }

    protected boolean m_40610_(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        return true;
    }

    @Nonnull
    public InteractionResult m_40576_(BlockPlaceContext context) {
        Level world = context.m_43725_();
        BlockPos pos = context.m_8083_();
        Player player = context.m_43723_();
        BlockState state = world.m_8055_(pos);
        Block block = state.m_60734_();
        ItemStack itemstack = context.m_43722_();
        if (itemstack.m_41619_()) {
            return InteractionResult.FAIL;
        }
        BlockState toPlace = this.m_40614_().m_5573_(context);
        PartSlot slot = PartSlot.NONE;
        if (this.m_40614_() instanceof IPartBlock) {
            slot = ((IPartBlock)this.m_40614_()).getSlotFromState(world, pos, toPlace);
        }
        if (!block.m_6864_(state, context) && !this.canFitInside(block, world, pos, slot)) {
            pos = pos.m_142300_(context.m_43719_());
            state = world.m_8055_(pos);
            block = state.m_60734_();
        }
        if (player.m_36204_(pos, context.m_43719_(), itemstack)) {
            toPlace = this.m_40614_().m_5573_(context);
            if (this.m_40614_() instanceof IPartBlock) {
                slot = ((IPartBlock)this.m_40614_()).getSlotFromState(world, pos, toPlace);
            }
            if (this.canFitInside(block, world, pos, slot)) {
                if (this.placeBlockAtInternal(itemstack, player, world, pos, toPlace, slot)) {
                    SoundType soundtype = toPlace.m_60734_().getSoundType(toPlace, (LevelReader)world, pos, (Entity)player);
                    world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                    itemstack.m_41774_(1);
                }
                return InteractionResult.SUCCESS;
            }
            if (this.placeBlockAtInternal(itemstack, player, world, pos, toPlace, slot)) {
                SoundType soundtype = toPlace.m_60734_().getSoundType(toPlace, (LevelReader)world, pos, (Entity)player);
                world.m_5594_(player, pos, soundtype.m_56777_(), SoundSource.BLOCKS, (soundtype.m_56773_() + 1.0f) / 2.0f, soundtype.m_56774_() * 0.8f);
                itemstack.m_41774_(1);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.FAIL;
    }

    private boolean canFitInside(Block block, Level world, BlockPos pos, PartSlot slot) {
        if (block != Registration.MULTIPART_BLOCK) {
            return false;
        }
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof MultipartTE) {
            MultipartTE.Part part = ((MultipartTE)te).getParts().get((Object)slot);
            return part == null;
        }
        return false;
    }

    @Nullable
    private BlockEntity createTileEntity(BlockPos pos, BlockState state) {
        Block block = state.m_60734_();
        if (block instanceof EntityBlock) {
            EntityBlock entityBlock = (EntityBlock)block;
            return entityBlock.m_142194_(pos, state);
        }
        return null;
    }

    protected boolean m_7429_(@Nonnull BlockPlaceContext context, @Nonnull BlockState state) {
        return false;
    }

    private boolean placeBlockAtInternal(ItemStack stack, Player player, Level world, BlockPos pos, BlockState newState, @Nonnull PartSlot slot) {
        BlockEntity te = world.m_7702_(pos);
        if (te instanceof MultipartTE) {
            BlockEntity tileEntity = this.createTileEntity(pos, newState);
            if (!(tileEntity instanceof GenericTileEntity) || stack.m_41783_() != null) {
                // empty if block
            }
            ((MultipartTE)te).addPart(slot, newState, tileEntity);
            return true;
        }
        BlockState multiState = Registration.MULTIPART_BLOCK.m_49966_();
        if (!world.m_7731_(pos, multiState, 19)) {
            return false;
        }
        BlockState state = world.m_8055_(pos);
        if (state.m_60734_() == Registration.MULTIPART_BLOCK) {
            MultipartItemBlock.m_40582_((Level)world, (Player)player, (BlockPos)pos, (ItemStack)stack);
            te = world.m_7702_(pos);
            if (te instanceof MultipartTE) {
                BlockEntity tileEntity = this.createTileEntity(pos, newState);
                if (!(tileEntity instanceof GenericTileEntity) || stack.m_41782_()) {
                    // empty if block
                }
                ((MultipartTE)te).addPart(slot, newState, tileEntity);
                return true;
            }
            newState.m_60734_().m_6402_(world, pos, newState, (LivingEntity)player, stack);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                CriteriaTriggers.f_10591_.m_59469_(serverPlayer, pos, stack);
            }
        }
        return true;
    }
}

